	/*bison file for Universal Scripting Language v 1.0
	*/
%{
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "error.h"
#include "tree.h"

 	/*prototyp funkce yylex*/
int yylex();

extern SCRIPT*	theScript;
%}

	/*Token definitions
	  radek %start script urcuje startovni symbol od ktereho se pokusime skript odvodit.
          je dulezite vedet kde yacit, nemuzeme zacit skript odvozovat od jakehokoliv prikladu.
          zacneme od zacatku*/
%start script


	/*tato unie v sobe schovava vsechny datovy typy ktere mohou mit uzly v AST stromu.*/
%union
{
	struct SCRIPT*	script;		/*kolekce funkci*/
	struct TOPLEVEL* toplevel;
	struct FUNCTION* function;	
	struct IDENTIFIER *identifiers;
	struct EXPRESSION* expression;
	struct DECLARATION* declaration;
	struct FORINIT*	forinit;
	struct STATEMENT* statement;
	struct LVALUE*	lvalue;
	struct TYPE*	type;

	char* identifier;			//identifikator
	int   intconst;				//integer konstanta
	double doubleconst;			//double konstanta
	char* stringconst;			//retezcova konstanta
};

	/* definice symbolu ktere mimojine vraci funkce yylex. Bison pro n vygenruje konstanty. Prvni bude mit
	   cislo 258. ASCII tabulka ma 256 znaku, 1 se vynecha a mame 258*/
%token 
tIF tELSE tFOR tWHILE tFUNCTION tRETURN tAND tEQUALS
tGEQUALS tLEQUALS tNEQUALS tOR tINTCONST tSTRINGCONST tIDENTIFIER tDOUBLECONST
tINC tDEC tPLUSASSIGN tMINUSASSIGN tMULASSIGN tDIVASSIGN tMODASSIGN tSHLASSIGN tSHRASSIGN
tSHL tSHR tANDASSIGN tORASSIGN tEXTERN tINT tSTRING tDOUBLE tVOID tNA

	/*u nekterych symbolu budeme potrebovat znak jejich puvodni hodnotu a ne jejich repreyentcai v podobe ciselne
          konstanty. Napriklad tINTCONST repreyentuje ze ve skriptu bylo rozpoznano cislo, tak by se nam hodilo vedet
          co to bylo ya cislo a ne jen ze to bylo cislo. U takovych symbolu kde se chceme vratit k puvodni hodnote potrebujeme 
	  vedet jakeho jsou typu. To je definovane v unii vyse. Tady v nasledujicich ctyrech radkach zacinajicich %token
          jen dame vedet o ktere jde. Potom tedy tIDENTIFIER bude ukazatel na retezec, tINTCONST integer cislo atd.*/
%token <identifier> tIDENTIFIER
%token <intconst> tINTCONST
%token <stringconst> tSTRINGCONST
%token <doubleconst> tDOUBLECONST
	/*nasledujici radky vlastne definuji datovy typ uylu v AST stromu. Datove typy jsou definovany v unii vyse
	a my tady rekneme jakym uzlum ve stromu prislusi.
	*/
%type <script> script
%type <toplevel> toplevels netoplevels toplevel
%type <function> function
%type <identifiers> identifiers
%type <expression> initialization expression unaryexpression unarypostfixexpression exps neexps
%type <declaration> declaration formals simpledeclaration neformals formal
%type <forinit> forinits neforinits forinit
%type <statement> nestatement statement compoundstatement
%type <lvalue> lvalue
%type <type> type

	/*vyporadani se s konflikty ) a else*/
%left ')'
%left tELSE

	/*priorita operatoru
	i kdyz je to matouci, tak neniysi prioritu maji operatory z prvniho radku. Pise se to tedy o nejniysi priority
        k nejvyssi, i kdyz logictejsi by to mozna bylo obracene. Nejvyssi prioritu ma tedy %. To ze maji operace prirazeni
        nejnizsi prioritu dava smysl. pac nejdriv vzdycky chceme vyhodnoti celou pravou stranu vyrazu a pak teprve to nekam
        ulozit.
	*/
%left '=' tPLUSASSIGN tMINUSASSIGN tMULASSIGN tDIVASSIGN tMODASSIGN tSHLASSIGN tSHRASSIGN tANDASSIGN tORASSIGN
%left tOR tAND tSHL tSHR '|' '&'
%left tEQUALS tNEQUALS tLEQUALS tGEQUALS '<' '>'
%left '+' '-'
%left '*' '/'
%left '%' 

%%		/*produkcni pravidla*/

script : toplevels
	{theScript = makeSCRIPT($1);}
	;

toplevels : /*prazne*/
	{$$ = NULL;}
	| netoplevels
	{$$ = $1;}
	;

netoplevels : toplevel
	{$$ = $1;}
	| toplevel netoplevels
	{$$ = $1; $$->next = $2;}
	;

toplevel : function
	{$$ = makeTOPLEVELfunction($1);}
	;

	//deklarace promenne nebo vice promennych
	//jako a = 0; nebo a,b,c = 0;
declaration : identifiers initialization ';'
	{$$ = makeDECLARATIONvariable($1,$2);}
	;

simpledeclaration : tIDENTIFIER initialization
	{$$ = makeDECLARATIONsimplevar($1,$2);}
	;

identifiers : tIDENTIFIER
	{$$ = makeIDENTIFIER($1);}
	| tIDENTIFIER ',' identifiers
	{$$ = makeIDENTIFIER($1); $$->next = $3;}
	;

initialization : /*empty*/
	{$$ = NULL;}
	| '=' expression
	{$$ = $2;}
	;

type : tINT
       	{$$ = makeTYPEint();}
	| tDOUBLE
	{$$ = makeTYPEdouble();}
	| tSTRING
	{$$ = makeTYPEstring();}
	| tVOID
	{$$ = makeTYPEvoid();}
	;

function : tIDENTIFIER '(' formals ')' compoundstatement
	{$$ = makeFUNCTION($1,$3,$5);}
	| tEXTERN '<' tSTRINGCONST '>' type tIDENTIFIER '(' tINTCONST ')'
	{$$ = makeFUNCTIONextern($3,$5,$6,$8);}
	| tEXTERN '<' tSTRINGCONST '>' type tIDENTIFIER '(' tNA ')'
	{$$ = makeFUNCTIONextern($3,$5,$6,-1);}
	;

formals : /*empty*/
	{$$ = NULL;}
	| neformals
	{$$ = $1;}
	;

neformals : formal
	{$$ = $1;}
	| formal ',' neformals
	{$$ = $1; $$->next = $3;}
	;

formal : tIDENTIFIER
	{$$ = makeDECLARATIONformal($1);}
	;

compoundstatement : '{' '}'
	{$$ = NULL;}
	| '{' nestatement '}'
	{$$ = $2;}
	;

nestatement : statement
	{$$ = $1;}
	| nestatement statement
	{$$ = makeSTATEMENTsequence($1,$2);}
	;

statement : ';'
	{$$ = makeSTATEMENTskip();}
	| tRETURN ';'
	{$$ = makeSTATEMENTreturn(NULL);}
	| tRETURN expression ';'
	{$$ = makeSTATEMENTreturn($2);}
	| tIF '(' expression ')' statement
	{$$ = makeSTATEMENTif($3,makeSTATEMENTscope($5));}
	| tIF '(' expression ')' statement tELSE statement
	{$$ = makeSTATEMENTifelse($3,makeSTATEMENTscope($5),makeSTATEMENTscope($7));}
	| tWHILE '(' expression ')' statement
	{$$ = makeSTATEMENTwhile($3,$5);}
	| tFOR '(' forinits ';' expression ';' exps ')' statement
	{$$ = makeSTATEMENTfor($3,$5,$7,makeSTATEMENTscope($9));}
	| compoundstatement
	{$$ = makeSTATEMENTscope($1);}
	| declaration
	{$$ = makeSTATEMENTdeclaration($1);}
	| expression ';'
	{$$ = makeSTATEMENTexpression($1);}
	;

forinits : /*empty*/
	{$$ = NULL;}
	| neforinits
	{$$ = $1;}
	;

neforinits : forinit
	{$$ = $1;}
	| forinit ',' neforinits
	{$$ = $1; $$->next = $3;}
	;

forinit : simpledeclaration
	{$$ = makeFORINITdeclaration($1);}
	| expression
	{$$ = makeFORINITexpression($1);}
	;

expression : lvalue '=' expression
	{$$ = makeEXPRESSIONassignment($1,$3);}
	| expression tEQUALS expression
	{$$ = makeEXPRESSIONequals($1,$3);}
	| expression tNEQUALS expression
	{$$ = makeEXPRESSIONnequals($1,$3);}
	| expression '<' expression
	{$$ = makeEXPRESSIONless($1,$3);}
	| expression '>' expression
	{$$ = makeEXPRESSIONgreater($1,$3);}
	| expression tLEQUALS expression
	{$$ = makeEXPRESSIONlequals($1,$3);}
	| expression tGEQUALS expression
	{$$ = makeEXPRESSIONgequals($1,$3);}
	| expression '+' expression
	{$$ = makeEXPRESSIONplus($1,$3);}
	| expression '-' expression
	{$$ = makeEXPRESSIONminus($1,$3);}
	| expression '*' expression
	{$$ = makeEXPRESSIONmul($1,$3);}
	| expression '/' expression
	{$$ = makeEXPRESSIONdiv($1,$3);}
	| expression '%' expression
	{$$ = makeEXPRESSIONmod($1,$3);}
	| expression tAND expression
	{$$ = makeEXPRESSIONand($1,$3);}
	| expression tOR expression
	{$$ = makeEXPRESSIONor($1,$3);}
	| lvalue tINC
	{$$ = makeEXPRESSIONpostinc($1);}
	| tINC lvalue
	{$$ = makeEXPRESSIONprefinc($2);}
	| lvalue tDEC
	{$$ = makeEXPRESSIONpostdec($1);}
	| tDEC lvalue
	{$$ = makeEXPRESSIONprefdec($2);}
	| lvalue tPLUSASSIGN expression
	{$$ = makeEXPRESSIONplusassign($1,$3);}
	| lvalue tMINUSASSIGN expression
	{$$ = makeEXPRESSIONminusassign($1,$3);}
	| lvalue tMULASSIGN expression
	{$$ = makeEXPRESSIONmulassign($1,$3);}
	| lvalue tDIVASSIGN expression
	{$$ = makeEXPRESSIONdivassign($1,$3);}
	| lvalue tMODASSIGN expression
	{$$ = makeEXPRESSIONmodassign($1,$3);}
	| expression tSHL expression
	{$$ = makeEXPRESSIONshl($1,$3);}
	| expression tSHR expression
	{$$ = makeEXPRESSIONshr($1,$3);}
	| lvalue tSHLASSIGN expression
	{$$ = makeEXPRESSIONshlassign($1,$3);}
	| lvalue tSHRASSIGN expression
	{$$ = makeEXPRESSIONshrassign($1,$3);}
	| lvalue tANDASSIGN expression
	{$$ = makeEXPRESSIONandassign($1,$3);}
	| lvalue tORASSIGN expression
	{$$ = makeEXPRESSIONorassign($1,$3);}
	| expression '&' expression
	{$$ = makeEXPRESSIONbitand($1,$3);}
	| expression '|' expression
	{$$ = makeEXPRESSIONbitor($1,$3);}
	| unaryexpression
	{$$ = $1;}
	;

unaryexpression : '-' unaryexpression
	{$$ = makeEXPRESSIONuminus($2);}
	| '!' unaryexpression
	{$$ = makeEXPRESSIONnot($2);}
	| unarypostfixexpression
	{$$ = $1;}
	;

unarypostfixexpression : tINTCONST
	{$$ = makeEXPRESSIONintconst($1);}
	| tSTRINGCONST
	{$$ = makeEXPRESSIONstringconst($1);}
	| tDOUBLECONST
	{$$ = makeEXPRESSIONdoubleconst($1);}
	| lvalue
	{$$ = makeEXPRESSIONlvalue($1);}
	| '(' expression ')'
	{$$ = $2;}
	| tIDENTIFIER '(' exps ')'			/*volani funkce*/
	{$$ = makeEXPRESSIONcall($1,$3);}
	;

exps : /*empty*/
	{$$ = NULL;}
	| neexps
	{$$ = $1;}
	;

neexps : expression
	{$$ = $1;}
	| expression ',' neexps
	{$$ = $1; $$->next = $3;}
	;

	/*LVALUE zachyti prirazeni vyrazu promenne, coz je ted to same jako
	deklarace samotne promenne a jeji inicilizace kdyz se nemusi zadavat datovy typ
	promennych
	*/
lvalue : tIDENTIFIER
	{$$ = makeLVALUEidentifier($1);}
	;

